//
//  GMSSettingsURLViewController.m
//  GMS Sample
//
//  Created by Arkady on 8/8/13.
//  Copyright (c) 2013 Genesys. All rights reserved.
//

#import "GMSSettingsURLViewController.h"
#import "GMSAppDelegate.h"
#import "GMSSettingsURLAddViewController.h"

@interface GMSSettingsURLViewController ()

@end

@implementation GMSSettingsURLViewController


- (void)viewDidLoad
{
    [super viewDidLoad];

    // Uncomment the following line to preserve selection between presentations.
    // self.clearsSelectionOnViewWillAppear = NO;
 
    // Uncomment the following line to display an Edit button in the navigation bar for this view controller.
    // self.navigationItem.rightBarButtonItem = self.editButtonItem;
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    // Return the number of sections.
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    // Return the number of rows in the section.
    GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
    return [appDelegate.serverURLs count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"GMSURLCell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    
    // Configure the cell...
    GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
    cell.textLabel.text = appDelegate.serverURLs[indexPath.row];
    
    cell.imageView.alpha = (indexPath.row == appDelegate.serverURLSelected) ? 1 : 0;

    return cell;
}

#pragma mark - Table view delegate

//To maintain compatibility with iOS 5
- (void)tableView:(UITableView *)tableView accessoryButtonTappedForRowWithIndexPath:(NSIndexPath *)indexPath
{
    [self performSegueWithIdentifier: @"editURL" sender: [tableView cellForRowAtIndexPath: indexPath]];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
    appDelegate.serverURLSelected = indexPath.row;

    UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    _currentSelection.text = cell.textLabel.text;
    
    [tableView reloadData];
    double delayInSeconds = 0.25;
    dispatch_time_t popTime = dispatch_time(DISPATCH_TIME_NOW, delayInSeconds * NSEC_PER_SEC);
    dispatch_after(popTime, dispatch_get_main_queue(), ^(void){
        [self.navigationController popViewControllerAnimated:YES];
    });
}

// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
       
        if (appDelegate.serverURLSelected == indexPath.row && appDelegate.serverURLSelected == [appDelegate.serverURLs count] - 1) {
            appDelegate.serverURLSelected--;
        }
        [appDelegate.serverURLs removeObjectAtIndex:indexPath.row];
        
        [tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:YES];
        [tableView reloadData];
    }
}

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
    GMSSettingsURLAddViewController *segmentVC = segue.destinationViewController;
    segmentVC.parentTableView = self.tableView;
    
    NSString *dstText;

    if ([segue.identifier isEqualToString:@"addURL"]) {
        _currentSelection.text = @"";
        appDelegate.serverURLSelected = -1;
        dstText = @"http://";
    }

    if ([segue.identifier isEqualToString:@"editURL"]) {
        dstText = ((UITableViewCell *)sender).textLabel.text;
        segmentVC.editIndex = [self.tableView indexPathForCell:sender].row;
    }
    
    //We access target View Controller view property to force it to load child urlTextField. Otherwise, it's not instantiated here.
    if ([segmentVC view]) {
        segmentVC.urlTextField.text = dstText;
    }
    
}


@end
